#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-LxiROOc2A9o6Wu4bJFxtwj
key:                  dhall-1.41.2-LxiROOc2A9o6Wu4bJFxtwj
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  ddfc493ae064cb76c5b54419a75451d4
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-LxiROOc2A9o6Wu4bJFxtwj
depends:
    Diff-0.4.1-93VJPKxRfUy8kQaaERgetd
    aeson-2.1.2.1-5xA96pEAe1OF80YjsNpBtK
    aeson-pretty-0.8.10-1dlwPC4Gr0U23GIUJQ9AUw
    ansi-terminal-0.11.5-XBGI19OWrE6RSltGekvjf
    atomic-write-0.2.0.7-AXKXHT1QwI52ZutxCgkqi0 base-4.16.4.0
    base16-bytestring-1.0.2.0-46ZA5fToFTG4nJXF5V42II
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-BQIgiVKdDDDGmlHWIYlRBM
    cborg-0.2.9.0-EZvn3mnm6tL70su98x8Lz2
    cborg-json-0.2.5.0-JGPCC4iBx5nIS2H62UGOjz containers-0.6.5.1
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    cryptohash-sha256-0.11.102.1-2CVZSMuarDdBX9zBpo2mgi
    data-fix-0.3.2-D3V7CCvHJV18I2KbQg3QRn deepseq-1.4.6.1
    directory-1.3.6.2 dotgen-0.4.3-GrGnAzxXk0NF0mUN2K7zar
    either-5.0.2-AtnUZUApvcr1OFvF4tXCEc exceptions-0.10.4
    filepath-1.4.2.2 half-0.3.1-6kyap03fMurHyTV5Vm6Zpn
    hashable-1.4.4.0-CxCIesSa4aLFiFeBLAsQal haskeline-0.8.2
    http-client-0.7.17-38qa29csmnJ2dnEtoGiG1
    http-client-tls-0.3.6.3-1kfplKzGE4w9BkNo49YcN7
    http-types-0.12.4-BeuRrGxb4N4IPcT7RjRHis
    indexed-traversable-0.1.4-BqNS4MNpBRx2vl8YrAPJH8
    lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
    megaparsec-9.6.1-L1ZGjccQdofF1Rb6tkX7D0
    mmorph-1.2.0-86rQZSuTSAZIoeBosVXsFi mtl-2.2.2
    network-uri-2.6.4.2-HdtZVRdZv9IE2UHpLGWumM
    optparse-applicative-0.17.1.0-FmysOOLyJPZK6ulyCvrib9
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    parsers-0.12.11-3Olv36rVcwNKjCPKUxIaL4
    pretty-simple-4.1.2.0-FEokIrt47mg35oEJIHdb35
    prettyprinter-1.7.1-CIIVRJfY0omENAvTZv71tT
    prettyprinter-ansi-terminal-1.1.3-HXcvQb59Iqn8w8qEbZH6z1
    profunctors-5.6.2-6QD8D6RGxabIMxmYDavcBB
    repline-0.4.2.0-8F4hfQj1tzA4brx66W1hS8
    scientific-0.3.7.0-7p41gUaaSP7BrDOTk8p39O
    serialise-0.2.6.1-BLrYfUFg84MKiKtxQLW2tN template-haskell-2.18.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-KEpOL86j4qE374jsxomMl6
    text-short-0.1.6-BlBwhLn6RgVGU82Vvt7Q74
    th-lift-instances-0.1.20-GMum5yc88r19CkG18L9b6a time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-9qtKP8IRTHnKAJSp2mdpwo
    uri-encode-1.5.0.7-8olLvkzeNMUHaXDP3QU74U
    vector-0.13.1.0-HRMJcTNtHmH9PMIsGjP73X

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

